#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#############################################################################
# Copyright (c): 2010-2020, Huawei Tech. Co., Ltd.
# Date         : 2018-03-26
# Description  : gsplatform.py is a utility to do something for platform information.
#############################################################################

""" The following platform framework is used to handle any differences between
    the platform's we support.  The GenericPlatform class is the base class
    that a supported platform extends from and overrides any of the methods
    as necessary.
"""

try:
    import sys
    sys.path.append(sys.path[0] + "/../../")

    from gspylib.common.ErrorCode import ErrorCode
    from gspylib.os.platform.suse_platform import SLESPlatform
    from gspylib.os.platform.redhat_platform import RHELPlatform
    from gspylib.os.platform.get_platform import GetPlatform
    from gspylib.os.platform import support_platform
except Exception as ie:
    sys.exit("[GAUSS-52200] : Unable to import module: %s." % str(ie))

KERNAL_FLAG = ""


# Requirements:
# 1. ulimit, ntpq, source, kerberos is not found under system path
class Platform(GetPlatform):
    """
    get os distname, version, currentid
    """

    def __init__(self):
        GetPlatform.__init__(self)


class UserPlatform():
    """
    manage Red Hat Enterprise Linux command,config or service for muti-platform
    """

    def __init__(self, kernel_flag=KERNAL_FLAG):
        """
        function : Check support OS version and init OS class
        """
        gs_platform = Platform()
        dist_name, _, _ = gs_platform.dist()
        lower_dist_name = dist_name.lower()
        if lower_dist_name not in support_platform.SUPPORT_WHOLE_PLATFORM_LIST:
            raise Exception(ErrorCode.GAUSS_519["GAUSS_51900"] +
                            "Supported platforms are: %s." % str(support_platform.SUPPORT_WHOLE_PLATFORM_LIST))

        if lower_dist_name == support_platform.SUSE:
            self.userPlatform = SLESPlatform(kernel_flag)
        else:
            self.userPlatform = RHELPlatform(kernel_flag)

        try:
            self.userPlatform.getCurrentPlatForm()
        except Exception as e:
            raise Exception(str(e))


# global platform class
g_Platform = UserPlatform().userPlatform
