#!/usr/bin/env python3
#-*- coding:utf-8 -*-

try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.hardware.gsmemory import g_memory
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckMemInfo(BaseItem):
    def __init__(self):
        super(CheckMemInfo, self).__init__(self.__class__.__name__)

    def doCheck(self):
        totalMem_bit = g_memory.getMemTotalSize()
        totalMem_g = totalMem_bit // 1024 // 1024 // 1024
        self.result.rst = ResultStatus.OK
        self.result.raw = "%s bit" % totalMem_bit
        self.result.val = "totalMem: %sG" % totalMem_g
