#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckXid(BaseItem):
    def __init__(self):
        super(CheckXid, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "select pg_catalog.txid_current();"
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        num = int(output)
        self.result.raw = sqlcmd
        self.result.val = "The xid value is %s" % output
        if (num <= 1000000000):
            self.result.rst = ResultStatus.OK
        elif (num <= 1800000000):
            self.result.rst = ResultStatus.WARNING
        else:
            self.result.rst = ResultStatus.NG
