#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckPgxcgroup(BaseItem):
    def __init__(self):
        super(CheckPgxcgroup, self).__init__(self.__class__.__name__)
        self.version = None

    def preCheck(self):
        # check the threshold was set correctly
        if (not self.threshold.__contains__('version')):
            raise Exception("version can not be empty")
        self.version = self.threshold['version']

    def doCheck(self):
        if (self.version == "V1R7C10"):
            sqlcmd = "select count(group_name) from pg_catalog.pgxc_group" \
                     " where in_redistribution='true' OR in_redistribution='y';"
        else:
            sqlcmd = "select count(group_name) from pg_catalog.pgxc_group" \
                     " where in_redistribution='y' OR in_redistribution='t';"
        self.result.raw = sqlcmd
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)

        if (output != '0'):
            self.result.rst = ResultStatus.NG
            self.result.val = "Cluster not completed redistribution."
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "The cluster has been redistributed."
