#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckPMKData(BaseItem):
    def __init__(self):
        super(CheckPMKData, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "select proname,pronamespace from pg_catalog.pg_proc" \
                 " where pronamespace not in (select oid from pg_catalog.pg_namespace);"
        self.result.raw = sqlcmd
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        if (output == ""):
            self.result.rst = ResultStatus.OK
            self.result.val = "No exception data in PMK."
        else:
            self.result.rst = ResultStatus.NG
            self.result.val = "PMK contains exception data: \n%s" % output

    def doSet(self):
        sqlcmd = "drop schema pmk cascade;"
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres",
                                       self.mpprcFile)

        self.result.val = output
