#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckCatchup(BaseItem):
    def __init__(self):
        super(CheckCatchup, self).__init__(self.__class__.__name__)

    def doCheck(self):
        cmd = "ps -ef |grep '^<%s\>' | grep '\<gaussdb\>' | grep -v grep | awk '{print $2}' |\
              (while read arg; do gstack $arg | grep CatchupMain; done) 2>/dev/null" % self.user
        output = SharedFuncs.runShellCmd(cmd)
        if (output != ""):
            self.result.rst = ResultStatus.NG
            self.result.val = "The gatchdb process stack contains the CatchupMain function."
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "The gatchdb process stack not contains the CatchupMain function."
        self.result.raw = cmd
