#!/usr/bin/env python3
# -*- coding:utf-8 -*-
# Add parameter: the logic cluster name
PARA_CHECK_LIST = ["-t", "-h", "-m", "--mode",
                   "-i", "-j", "-U", "-u", "-G", "-g", "--alarm-type", "-n", "-g",
                   "-N", "--autostart", "--time-out", "--alarm-component",
                   "--parallel-jobs", '--redis-mode', "--ring-num", "--virtual-ip",
                   "--nodeName", "--name", "--failure-limit"]
PATH_CHEKC_LIST = ["-M", "-o", "-f", "-X", "-P", "-s", "-R", "-Q", "--position", "-B",
                   "--backupdir", "--sep-env-file", "-l", "--logpath", "--backup-dir",
                   "--priority-tables", "--exclude-tables"]
VALUE_CHECK_LIST = ["|", ";", "&", "$", "<", ">", "`", "\\", "'", "\"", "{", "}", "(", ")", "[", "]", "~", "*", "?",
                    "!", "\n"]

# append ':' after short options if it required parameter
# append '=' after long options if it required parameter
# no child branch
common_options = ["-?", "--help", "-V", "--version", "-l:", "--uuid=", "--logAction=", "--logStep="]
gs_preinstall = ["-U:", "-G:", "-L", "-M:", "--skip-os-set", "-X:", "--alarm-type=", "--alarm-server-addr=",
                 "--env-var=", "--sep-env-file=", "--skip-hostname-set", "--non-interactive"] + common_options
gs_install = ["--dws-mode", "-X:", "--gsinit-parameter=", "--gtminit-parameter=",
              "--cn-guc=", "--dn-guc=", "--time-out=", "--alarm-component=",
              "--autostart=", "--product="] + common_options
gs_uninstall = ["-L", "--delete-data"] + common_options
gs_postuninstall = ["--delete-user", "--delete-group", "--delete-virtual-IP", "-U:", "-X:", "-L"] + common_options
gs_check = ["-e:", "-i:", "-U:", "-o:", "-L", "--hosts=", "--format=", "--cid=",
            "--disk-threshold=", "--time-out=", "--routing=", "--skip-items=",
            "--ShrinkNodes=", "--nodegroup-name=", "--skip-root-items", "--set"] + common_options

gs_shrink = ["--nodegroup-name=", "--parallel-jobs=", "-h:", "-f:",
             "--express", "--time-out=", "--rollback", "--checkdisk", "--add-to-elastic", "--online",
             "--skip-clean-node", "--check-consistency", "--redis-track-task="] + common_options
gs_sshexkey = ["--password=", "-f:", "-W:", "--skip-hostname-set"] + common_options
gs_backup = ["--backup-dir=", "--parameter", "--binary", "--all", "-h:", "-t:", "-X:", ] + common_options
gs_collector = ["--begin-time=", "--end-time=", "--keyword=", "--speed-limit=",
                "-h:", "-f:", "-o:", ] + common_options
gs_checkperf = ["--detail", "-o:", "-i:", "-U:", "-L", "--all"] + common_options
gs_ssh = ["-c:"] + common_options
gs_checkos = ["-h:", "-f:", "-o:", "-i:", "--detail", "-X:"] + common_options
gs_syncdata = ["-h:", "-W:"] + common_options

# gs_replace child branch
gs_replace_start = ["-t:", "-h:", "--time-out=", "--dws-mode", "--force"] + common_options
gs_replace_install = ["-t:", "--dws-mode", "-h:"] + common_options
gs_replace_config = ["-t:", "--dws-mode", "-h:", "--force"] + common_options
gs_replace_WarmStandby = ["-t:", "-X:", "--dws-mode"] + common_options

# gs_om child branch
gs_om_start = ["-t:", "-h:", "-I:", "--time-out=", "--az="] + common_options
gs_om_stop = ["-t:", "-h:", "-I:", "-m:", "--az=", "--mode="] + common_options
gs_om_restart = ["-t:", "--nodegroup-name=", "--time-out="] + common_options
gs_om_status = ["-t:", "-h:", "-o:", "--detail", "--json"] + common_options
gs_om_switch = ["-t:", "-h:", "-I:", "-D:", "--reset", "--time-out=", "--az="] + common_options
gs_om_startetcd = ["-t:"] + common_options
gs_om_managecn = ["-t:", "-m:", "-X:", "--rollback", "--mode="] + common_options
gs_om_changeip = ["-t:", "-X:", "--rollback"] + common_options
gs_om_generateconf = ["-t:", "-X:", "--distribute"] + common_options
gs_om_virtualip = ["-t:", "-m:", "-X:", "-L", "--mode=", "--virtual-ip="] + common_options
gs_om_cert = ["-t:", "-L", "--cert-file=", "--rollback"] + common_options
gs_om_kerberos = ["-t:", "-m:", "-U:", "-X:"] + common_options
gs_om_tablespace = ["-t:", "-h:"] + common_options
gs_om_estimate_addCN = ["-t:", "-m:", "--mode="] + common_options
gs_om_estimate_expand = ["-t:", "-m:", "--mode=", "-X:"] + common_options
gs_om_estimate_replace_warm_standby = ["-t:", "-m:", "--mode=", "-h:"] + common_options
gs_om_ec = ["-t:", "-m:", "--target=", "--key-files", "--all", "--force", "-N:",
            "--type=", "-U:", "-L"] + common_options
gs_om_javaUDF = ["-t:", "-m:", "--mode=", "-s:", "-d:"] + common_options
gs_om_postgis = ["-t:", "-m:", "--mode="] + common_options
gs_om_dailyAlarm = ["-t:", "-U:"] + common_options
gs_om_express = ["-t:", "-m:", "--mode=", "-h:", "--detail"] + common_options
gs_om_compare_cluster = ["-t:", "--remote-host=", "--remote-env-file="] + common_options
gs_om_license = ["-t:", "-m:", "--mode=", "-f:", "--features=", "-r", "--rollback"] + common_options
gs_om_isolate_stop = ["-t:", "-h:"] + common_options
gs_om_isolate_tostandby = ["-t:", "-h:"] + common_options
gs_om_isolate_restore = ["-t:", "-h:"] + common_options
gs_om_killsession = ["-t:", "--close-hba", "--restore-hba"] + common_options
gs_om_slow_node = ["-t:", "-m:", "--interval=", "--check-count=",
                   "--threshold=", "--wait-count="] + common_options
gs_om_refreshconf = ["-t:", "--remote-config-file=", "--lc-cluster", "--refresh-static-conf-only"] + common_options
gs_om_config_guc = ["-t:", "-m:", "--mode="] + common_options
gs_om_parse_static_conf = ["-t:", "--static-config-file=", "--lc-cluster"] + common_options
gs_om_parse_xml = ["-t:", "-X:", "--static-config-file=", "-m:", "--mode="] + common_options
gs_om_generate_xml = ["-t:", "--static-config-file=", "-o:"] + common_options
gs_om_parse_status_file = ["-t:", "-f:"] + common_options

# gs_expand child branch
gs_expand_schecheck = ["-t:", "--nodes=", "--redistribution", "--dilatation",
                       "--begin-time=", "--end-time=", "--white-list=", "--risk-assess"] + common_options
gs_expand_dilatation = ["-t:", "-X:", "--dws-mode", "--parallel-jobs=",
                        "--time-out=", "--nodegroup-name=", "--addto-elastic-group", "--dilatation-mode=",
                        "--express", "--schedule-path=", "--skip-clean-node", "--waiting-for-killing=",
                        "--new-nodegroup-name="] + common_options
gs_expand_redistribute = ["-t:", "--vacuum-full", "--fast-redis", "--parallel-jobs=",
                          "--build-redistb", "--dws-mode", "--redis-mode=", "--time-out=", "--priority-tables=",
                          "--failure-limit=", "--exclude-tables=", "--schedule-path=", "--check-consistency",
                          "--redis-track-task="] + common_options
gs_expand_crashclean = ["-t:", "-X:", "--dws-mode", "--express"] + common_options
# for resource control in data redistribution
gs_expand_resourcectl = ["-t:", "--resource-level="] + common_options
gs_expand_progress = ["-t:", "-X:"] + common_options

# parameter list for gs_scheduler
gs_scheduler = ["-t:", "--categoryid=", "--schedule-path=", "--crontab", "--parallel-min=",
                "--parallel-max=", "--priority=", "--parallel", "--alterinfo", "--category=",
                "--json", "--maintenance=", "--collector=", "--retrytimes", "--retrytimes-max=",
                "--get=", "--set="] + common_options

# parameter list for sub-action of gs_resize
gs_resize = ["-t:", "-X:", "--parallel-jobs=", "--rollback"] + common_options
gs_resize_clean = ["-t:", "-X:"] + common_options
gs_resize_progress = ["-t:", "-X:"] + common_options

# gs_upgradectl child branch
# AP and TP are same
gs_upgradectl_chose_strategy = ["-t:"] + common_options
# auto-upgrade parameter lists
gs_upgradectl_auto_upgrade = ["-t:", "-X:", "-M:", "--online", "--product=", "--binary-only"] + common_options
# auto-rollback parameter lists
gs_upgradectl_auto_rollback = ["-t:", "-X:", "--online", "--binary-only", "--ignore-host="] + common_options
# commit-upgrade parameter lists
gs_upgradectl_commit = ["-t:", "-X:", "--binary-only"] + common_options

# gs_loadbalance child branch
gs_loadbalance_install = ["-t:", "-X:", "-U:", "--master=", "--standby=", "--lvs-addr="] + common_options
gs_loadbalance_reload = ["-t:", "-X:", "-U:", "--lvs-addr="] + common_options
gs_loadbalance_uninstall = ["-t:", "-X:", "-U:"] + common_options

# gs_lcctl child branch
# create the logic cluster
gs_lcctl_create = ["-t:", "-h:", "-f:", "--name=", "--upgrade", "--high-perform",
                   "--non-interactive"] + common_options
# rollback the logic cluster
gs_lcctl_rollback = ["-t:", "--name="] + common_options
# transform a logic cluster to V3.0
gs_lcctl_transform = ["-t:", "--check"] + common_options
# add nodes to a logic cluster
gs_lcctl_add = ["-t:", "-h:", "-f:", "--name=", "--dilatation-mode=",
                "--time-out=", "--skip-clean-node", "--waiting-for-killing="] + common_options
# display message for logic cluster
gs_lcctl_display = ["-t:", "--lcname-only"] + common_options
# delete the logic cluster
gs_lcctl_delete = ["-t:", "--name=", "--elastic-group", "--add-to-elastic", "-h:", "-f:"] + common_options
# clean data node table
gs_lcctl_clean = ["-t:", "-h:", "--keep-name="] + common_options
gs_lcctl_progress = ["-t:", "--name=", "--option="] + common_options

ParameterDict = {
    "preinstall": gs_preinstall,
    "install": gs_install,
    "uninstall": gs_uninstall,
    "replaceinstall": gs_replace_install,
    "replaceconfig": gs_replace_config,
    "replacestart": gs_replace_start,
    "WarmStandby": gs_replace_WarmStandby,
    "checkos": gs_checkos,
    "syncdata": gs_syncdata,
    "schecheck": gs_expand_schecheck,
    "dilatation": gs_expand_dilatation,
    "redistribute": gs_expand_redistribute,
    "crashclean": gs_expand_crashclean,
    "resourcectl": gs_expand_resourcectl,
    "progress": gs_expand_progress,
    "checkperf": gs_checkperf,
    "check": gs_check,
    "shrink": gs_shrink,
    "auto_upgrade": gs_upgradectl_auto_upgrade,
    "chose_strategy": gs_upgradectl_chose_strategy,
    "commit_upgrade": gs_upgradectl_commit,
    "auto_rollback": gs_upgradectl_auto_rollback,
    "start": gs_om_start,
    "stop": gs_om_stop,
    "restart": gs_om_restart,
    "status": gs_om_status,
    "startetcd": gs_om_startetcd,
    "managecn": gs_om_managecn,
    "changeip": gs_om_changeip,
    "generateconf": gs_om_generateconf,
    "switch": gs_om_switch,
    "virtualip": gs_om_virtualip,
    "cert": gs_om_cert,
    "tablespace": gs_om_tablespace,
    "kerberos": gs_om_kerberos,
    "ec": gs_om_ec,
    "javaUDF": gs_om_javaUDF,
    "postgis": gs_om_postgis,
    "dailyAlarm": gs_om_dailyAlarm,
    "compare-cluster": gs_om_compare_cluster,
    "config-guc": gs_om_config_guc,
    "sshexkey": gs_sshexkey,
    "backup": gs_backup,
    "collector": gs_collector,
    "ssh": gs_ssh,
    "postuninstall": gs_postuninstall,
    "lcctlcreate": gs_lcctl_create,
    "lcctltransform": gs_lcctl_transform,
    "lcctlrollback": gs_lcctl_rollback,
    "lcctladd": gs_lcctl_add,
    "lcctldisplay": gs_lcctl_display,
    "lcctldelete": gs_lcctl_delete,
    "lcctlclean": gs_lcctl_clean,
    "lcctlprogress": gs_lcctl_progress,
    "loadbalance_install": gs_loadbalance_install,
    "loadbalance_reload": gs_loadbalance_reload,
    "loadbalance_uninstall": gs_loadbalance_uninstall,
    "estimate_addCN": gs_om_estimate_addCN,
    "estimate_expand": gs_om_estimate_expand,
    "estimate_replace_warm_standby": gs_om_estimate_replace_warm_standby,
    "isolate_stop": gs_om_isolate_stop,
    "isolate_tostandby": gs_om_isolate_tostandby,
    "isolate_restore": gs_om_isolate_restore,
    "killsession": gs_om_killsession,
    "slow_node": gs_om_slow_node,
    "cr_resize": gs_resize,
    "cr_clean": gs_resize_clean,
    "cr_progress": gs_resize_progress,
    "express": gs_om_express,
    "license": gs_om_license,
    "refreshconf": gs_om_refreshconf,
    "parse-static-conf": gs_om_parse_static_conf,
    "parse-xml": gs_om_parse_xml,
    "generate-xml": gs_om_generate_xml,
    "parse-status-file": gs_om_parse_status_file,
    "scheduler": gs_scheduler
}

# List of scripts with the -t parameter
# add gs_lcctl
special_list = ["gsom", "replace", "backup", "upgradectl", "expand",
                "clusterresize", "shrink", "loadbalance", "lcctl"]

estimate_list = ["expand", "addCN", "replace", "warm-standby"]
# The -t parameter list
action_om = ["start", "stop", "status", "startetcd", "managecn", "switch",
             "changeip", "generateconf", "estimate", "virtualip",
             "cert", "tablespace", "kerberos", "ec", "javaUDF", "postgis",
             "dailyAlarm", "express", "compare-cluster", "restart", "license",
             "isolate_stop", "isolate_tostandby", "isolate_restore",
             "killsession", "slow_node", "refreshconf", "config-guc",
             "parse-static-conf", "parse-xml", "generate-xml", "parse-status-file"
             ]
action_replace = ["install", "config", "start", "warm-standby"]
action_upgradectl = ["chose-strategy", "auto-upgrade", "auto-rollback", "commit-upgrade"]
# add "resourcectl" for resource control in data redistribution
action_expand = ["dilatation", "redistribute", "crashclean", "resourcectl", "progress", "schecheck"]
action_resize = ["resize", "clean", "progress"]
action_loadbalance = ["install", "reload", "uninstall"]
# add gs_lcctl for a logic cluster
action_lcctl = ["create", "rollback", "add", "display", "delete", "clean", "progress", "transform"]
