#!/usr/bin/env python3
# -*- coding:utf-8 -*-
###########################
# instance role
###########################
# init value
INSTANCE_ROLE_UNDEFINED = -1
# cm_server
INSTANCE_ROLE_CMSERVER = 0
# gtm
INSTANCE_ROLE_GTM = 1
# etcd
INSTANCE_ROLE_ETCD = 2
# cn
INSTANCE_ROLE_COODINATOR = 3
# dn
INSTANCE_ROLE_DATANODE = 4
# cm_agent
INSTANCE_ROLE_CMAGENT = 5

###########################
# ID num
###########################
BASE_ID_CMSERVER = 1
BASE_ID_GTM = 1001
BASE_ID_CMAGENT = 10001
BASE_ID_DUMMYDATANODE = 3001
BASE_ID_COORDINATOR = 5001
BASE_ID_DATANODE = 6001
BASE_ID_ETCD = 7001

# For primary/standby instance When the ID > 7000 , the new id is start from 40001
OLD_LAST_PRIMARYSTANDBY_BASEID_NUM = 7000
NEW_FIRST_PRIMARYSTANDBY_BASEID_NUM = 40000
# For salve instance When the ID > 5000 , the new id is start from 20001
OLD_LAST_DUMMYNODE_BASEID_NUM = 5000
NEW_FIRST_DUMMYNODE_BASEID_NUM = 20000

# master instance default port
MASTER_BASEPORT_CMS = 5000
MASTER_BASEPORT_GTM = 6000
# cm agent has no port, just occupancy index 5
MASTER_BASEPORT_CMAGENT = 0
MASTER_BASEPORT_COO = 8000
MASTER_BASEPORT_DATA = 40000
MASTER_BASEPORT_ETCD = 2379
# standby instance default port
STANDBY_BASEPORT_CMS = 5500
STANDBY_BASEPORT_GTM = 6500
# cm agent has no port, just occupancy index 5
STANDBY_BASEPORT_CMAGENT = 0
STANDBY_BASEPORT_COO = 8500
STANDBY_BASEPORT_DATA = 45000
STANDBY_BASEPORT_ETCD = 2380
# dummy standby instance default port
DUMMY_STANDBY_BASEPORT_DATA = 50000

###########################
# instance type. only for CN/DN
###########################
INSTANCE_TYPE_UNDEFINED = -1
# master
MASTER_INSTANCE = 0
# standby
STANDBY_INSTANCE = 1
# dummy standby
DUMMY_STANDBY_INSTANCE = 2

###########################
# instance number
###########################
MIRROR_COUNT_CMS = 2
MIRROR_COUNT_GTM = 2
MIRROR_COUNT_SSD = 2
# minimum number of nodes
MIRROR_COUNT_DATA = 3
# etcd number >=3 and <= 7
MIRROR_COUNT_ETCD_MIN = 3
MIRROR_COUNT_ETCD_MAX = 7
# max number of CN instance
MIRROR_COUNT_CN_MAX = 40
# max number of node
MIRROR_COUNT_NODE_MAX = 2048
# max number of DN instance(primary instance)
MIRROR_COUNT_DN_MAX = 4096
# min number of replication for CLUSTER_TYPE_SINGLE_PRIMARY_MULTI_STANDBY
MIRROR_COUNT_REPLICATION_MIN = 2
# max number of replicationfor CLUSTER_TYPE_SINGLE_PRIMARY_MULTI_STANDBY
MIRROR_COUNT_REPLICATION_MAX = 8
# max number of azPriority for CLUSTER_TYPE_SINGLE_PRIMARY_MULTI_STANDBY
AZPRIORITY_MAX = 10
# min number of azPriority for CLUSTER_TYPE_SINGLE_PRIMARY_MULTI_STANDBY
AZPRIORITY_MIN = 1
# dn port set step size for CLUSTER_TYPE_SINGLE_PRIMARY_MULTI_STANDBY
PORT_STEP_SIZE = 20

MIRROR_ID_COO = -1
MIRROR_ID_AGENT = -3
MIRROR_ID_ETCD = -5

# cluster type
CLUSTER_TYPE_SINGLE = "single"
CLUSTER_TYPE_MASTER_STANDBY = 'master-standby'
CLUSTER_TYPE_SINGLE_PRIMARY_MULTI_STANDBY = "single-primary-multi-standby"
CLUSTER_TYPE_SINGLE_INST = "single-inst"
CLUSTER_TYPE_MASTER_STANDBY_MULTI_AZ = 'master-standby-multi-az'

# env parameter
ENV_CLUSTERCONFIG = "CLUSTERCONFIGFILE"

# default config version, it is used by gs_upgrade
BIN_CONFIG_VERSION = 2
BIN_CONFIG_VERSION_SINGLE = 101
BIN_CONFIG_VERSION_SINGLE_PRIMARY_MULTI_STANDBY = 201
BIN_CONFIG_VERSION_SINGLE_INST = 301
BIN_CONFIG_VERSION_HTAP_INST = 302
BIN_CONFIG_VERSION_MASTER_STANDBY_MULTI_AZ = 501

BIN_CONFIG_VERSION_IPV6 = 3
BIN_CONFIG_VERSION_SINGLE_IPV6 = 102
BIN_CONFIG_VERSION_SINGLE_PRIMARY_MULTI_STANDBY_IPV6 = 202
BIN_CONFIG_VERSION_SINGLE_INST_IPV6 = 303
BIN_CONFIG_VERSION_HTAP_INST_IPV6 = 304
BIN_CONFIG_VERSION_MASTER_STANDBY_MULTI_AZ_IPV6 = 502

IPV6_VERSION_LIST = [BIN_CONFIG_VERSION_IPV6, BIN_CONFIG_VERSION_SINGLE_IPV6,
                     BIN_CONFIG_VERSION_SINGLE_PRIMARY_MULTI_STANDBY_IPV6, BIN_CONFIG_VERSION_SINGLE_INST_IPV6,
                     BIN_CONFIG_VERSION_HTAP_INST_IPV6, BIN_CONFIG_VERSION_MASTER_STANDBY_MULTI_AZ_IPV6]
# page size
PAGE_SIZE = 8192
MAX_IP_NUM = 3
NEW_MAX_IP_NUM = 10
CONFIG_IP_NUM = 1

# GPHOME
CLUSTER_TOOL_PATH = "/opt/huawei/wisequery"

g_dom = None

# The default network type is single plane
g_networkType = 0

azName1 = "AZ1"
azName2 = "AZ2"
azName3 = "AZ3"
AZNMAE_LIST = [azName1, azName2, azName3]
