/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.postgresql.pljava.jdbc.ResultSetBase;
import org.postgresql.pljava.jdbc.ResultSetField;
import org.postgresql.pljava.jdbc.SyntheticResultSetMetaData;

public class SyntheticResultSet
extends ResultSetBase {
    private final ResultSetField[] m_fields;
    private final ArrayList m_tuples;
    private final HashMap m_fieldIndexes;

    SyntheticResultSet(ResultSetField[] resultSetFieldArray, ArrayList arrayList) throws SQLException {
        super(arrayList.size());
        this.m_fields = resultSetFieldArray;
        this.m_tuples = arrayList;
        this.m_fieldIndexes = new HashMap();
        int n = this.m_fields.length;
        while (--n >= 0) {
            this.m_fieldIndexes.put(this.m_fields[n].getColumnLabel(), new Integer(n + 1));
        }
        Object[][] objectArray = (Object[][])this.m_tuples.toArray((T[])new Object[0][]);
        for (n = 0; n < objectArray.length; ++n) {
            int n2 = this.m_fields.length;
            while (--n2 >= 0) {
                Object object = objectArray[n][n2];
                if (object == null || this.m_fields[n2].canContain(object.getClass())) continue;
                throw new SQLException("Unable to store class " + object.getClass() + " in ResultSetField '" + this.m_fields[n2].getColumnLabel() + "' with OID " + this.m_fields[n2].getOID() + " (expected class: " + this.m_fields[n2].getJavaClass() + ")");
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.m_tuples.clear();
        super.close();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Integer n = (Integer)this.m_fieldIndexes.get(string.toUpperCase());
        if (n != null) {
            return n;
        }
        throw new SQLException("No such field: '" + string + "'");
    }

    @Override
    protected Object getObjectValue(int n) throws SQLException {
        return this.getCurrentRow()[n - 1];
    }

    protected final Object[] getCurrentRow() throws SQLException {
        int n = this.getRow();
        if (n < 1 || n > this.m_tuples.size()) {
            throw new SQLException("ResultSet is not positioned on a valid row");
        }
        return (Object[])this.m_tuples.get(n - 1);
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.getRow() == this.m_tuples.size();
    }

    @Override
    public boolean next() throws SQLException {
        int n = this.getRow();
        if (n < this.m_tuples.size()) {
            this.setRow(n + 1);
            return true;
        }
        return false;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new SyntheticResultSetMetaData(this.m_fields);
    }
}

