#!/usr/bin/env python3
#-*- coding:utf-8 -*-


try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.hardware.gsdisk import g_disk
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckInstallDiskUsage(BaseItem):
    def __init__(self):
        super(CheckInstallDiskUsage, self).__init__(self.__class__.__name__)

    def doCheck(self):
        flag = "Normal"
        path = "/boot"
        #Check space usage
        rateNum = round(g_disk.getDiskSpaceUsage(path), 2)
        self.result.raw += "[%s] space usage: %s%%\n" % (path, rateNum)
        if (rateNum > int(self.thresholdDn)):
            self.result.val += "Path(%s) space usage(%d%%)     " \
                               "Abnormal reason: The usage of the device disk space cannot be greater than %s%%.\n"\
                               % (path, rateNum, self.thresholdDn)
            flag = "Error"
        #Check inode usage
        status, _ = SharedFuncs.checkDiskInde(path, self.thresholdDn)
        if flag == "Normal" and status:
            self.result.rst = ResultStatus.OK
            self.result.val = "Install disk space are sufficient.\n"
        else:
            self.result.rst = ResultStatus.NG
