#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckEncoding(BaseItem):
    def __init__(self):
        super(CheckEncoding, self).__init__(self.__class__.__name__)

    def doCheck(self):
        cmd = "source /etc/profile 2>/dev/null; locale | grep '^LANG='"
        output = SharedFuncs.runShellCmd(cmd)
        self.result.raw = cmd
        if (output != ""):
            self.result.rst = ResultStatus.OK
        else:
            self.result.rst = ResultStatus.NG
        self.result.val = output
