#!/usr/bin/env python3
#-*- coding:utf-8 -*-

try:
    import sys
    import importlib
    importlib.reload(sys)
    import os
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
    from gspylib.os.gsnetwork import g_network
    from gspylib.os.platform import support_platform
    from gspylib.os.gsplatform import Platform
    from gspylib.os.gsplatform import g_Platform
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckNoCheckSum(BaseItem):
    def __init__(self):
        super(CheckNoCheckSum, self).__init__(self.__class__.__name__)

    def getOSversion(self):
        gs_platform = Platform()
        distname, version, _ = gs_platform.dist()
        return distname, version

    def doCheck(self):
        if (not os.path.isfile("/sys/module/sctp/parameters/no_checksums")):
            self.result.rst = ResultStatus.OK
            self.result.val = "The SCTP service is not used and the check item is skipped"
            return
        expect = "N"
        networkCardNum = self.service_network_adapt.NICNum
        networkConfigFile = SharedFuncs.getNetWorkConfFile(networkCardNum)
        networkBond = g_Platform.getNetworkBondModeInfo(networkConfigFile, networkCardNum)
        (distname, version) = self.getOSversion()
        distname = distname.lower()
        if distname in support_platform.RHEL_MASTER_PLATFORM_LIST \
                and version in ("6.4", "6.5") \
                and networkBond != "BondMode Null":
            expect = "Y"

        output = g_file.readFile('/sys/module/sctp/parameters/no_checksums')[0]
        if (output.strip() == expect):
            self.result.rst = ResultStatus.OK
            self.result.val = "Nochecksum value is %s,Check items pass." % output.strip()
        else:
            self.result.rst = ResultStatus.NG
            self.result.val = "Nochecksum value(%s) is not %s,Check items are not passed." % (output.strip(), expect)
