#!/usr/bin/env python3
# -*- coding:utf-8 -*-

try:
    import sys
    import importlib

    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckDiskConfig(BaseItem):
    def __init__(self):
        super(CheckDiskConfig, self).__init__(self.__class__.__name__)

    def doCheck(self):
        DiskInfoDict = {}
        ResultStr = ""
        cmd = "df -h -P | awk '{print $1,$2,$6}'"
        output = SharedFuncs.runShellCmd(cmd)
        diskList = output.split('\n')[1:]
        for disk in diskList:
            diskInfo = disk.split()
            DiskInfoDict[diskInfo[0]] = disk
        keys = list(DiskInfoDict.keys())
        keys.sort()
        for diskName in keys:
            ResultStr = "%s%s\n" % (ResultStr, DiskInfoDict.get(diskName))
        self.result.val = ResultStr
        self.result.rst = ResultStatus.OK
