#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#############################################################################
# Copyright (c): 2010-2020, Huawei Tech. Co., Ltd.
# Description  : memory.py is a utility to do something for memory information.
#############################################################################
try:
    import sys

    sys.path.append(sys.path[0] + "/../../")
    from gspylib.common.ErrorCode import ErrorCode
except ImportError as ie:
    sys.exit("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class memoryInfo(object):
    """
    function: Init the MemInfo options
    """

    def __init__(self):
        """
        function: Init the MemInfo options
        """

    @staticmethod
    def getMemUsedSize():
        """
        get used memory size
        """
        import psutil
        return psutil.virtual_memory().used

    @staticmethod
    def getMemFreeSize():
        """
        get free memory size
        """
        import psutil
        return psutil.virtual_memory().free

    @staticmethod
    def getSwapUsedSize():
        """
        get used swap size
        """
        import psutil
        return psutil.swap_memory().used

    @staticmethod
    def getSwapFreeSize():
        """
        get free swap size
        """
        import psutil
        return psutil.swap_memory().free

    @staticmethod
    def getSwapTotalSize():
        """
        function : Get swap memory total size
        input  : null
        output : total  memory size (byte)
        """
        import psutil
        total = 0
        try:
            total = psutil.swap_memory().total
        except Exception as e:
            raise Exception(ErrorCode.GAUSS_505["GAUSS_50502"] + "Error: %s" % str(e))
        return total

    @staticmethod
    def getMemTotalSize():
        """
        function : Get system virtual memory total size
        input  : null
        output : total virtual memory(byte)
        """
        import psutil
        total = 0
        try:
            total = psutil.virtual_memory().total
        except Exception as e:
            raise Exception(ErrorCode.GAUSS_505["GAUSS_50502"] + "Error: %s" % str(e))
        return total


g_memory = memoryInfo()
