/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;

public class SPIResultSetMetaData
extends AbstractResultSetMetaData {
    private final TupleDesc m_tupleDesc;

    public SPIResultSetMetaData(TupleDesc tupleDesc) {
        this.m_tupleDesc = tupleDesc;
    }

    @Override
    public final int getColumnCount() throws SQLException {
        return this.m_tupleDesc.size();
    }

    @Override
    public final boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    @Override
    public final String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.m_tupleDesc.getColumnName(n).toUpperCase();
    }

    @Override
    public final String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.getOid(n).getJavaClass().getName();
    }

    @Override
    protected final void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.m_tupleDesc.size()) {
            throw new SQLException("Invalid column index: " + n);
        }
    }

    @Override
    protected final Oid getOid(int n) throws SQLException {
        return this.m_tupleDesc.getOid(n);
    }

    @Override
    protected final int getFieldLength(int n) throws SQLException {
        return 0;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<T> ) not implemented yet.", "0A000");
    }
}

