/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgresql.pljava.jdbc.SPIConnection;

public class SPIDriver
implements Driver {
    private static final Logger s_logger = Logger.getLogger("org.postgresql.pljava.jdbc");
    private static final String s_defaultURL = "jdbc:default:connection";
    private static final int s_defaultURLLen = "jdbc:default:connection".length();
    private static final Connection s_defaultConn = new SPIConnection();
    private static final DriverPropertyInfo[] s_noInfo = new DriverPropertyInfo[0];

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return this.acceptsURL(string) ? s_defaultConn : null;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith(s_defaultURL) && (string.length() == s_defaultURLLen || string.charAt(s_defaultURLLen) == ':');
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return s_noInfo;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static Connection getDefault() {
        return s_defaultConn;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return s_logger;
    }

    static {
        try {
            DriverManager.registerDriver(new SPIDriver());
        }
        catch (SQLException sQLException) {
            throw new ExceptionInInitializerError(sQLException);
        }
    }
}

