#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#############################################################################
# Copyright (c): 2012-2017, Huawei Tech. Co., Ltd.
# Description  : ThreadPool.py is utility to support parallel control by multiprocess
#############################################################################
try:
    import threading
    import multiprocessing
    import subprocess
    import sys

    from multiprocessing.dummy import Pool as ThreadPool
except ImportError as ie:
    sys.exit("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class parallelTool(object):
    '''
    Class for multi-parallel controling one-hosts
    '''
    DEFAULT_PARALLEL_NUM = 12

    def __init__(self):
        '''
        Constructor
        '''

    @staticmethod
    def getCpuCount(parallelJobs=0):
        """
        function: get cpu set of current board
                  cat /proc/cpuinfo |grep processor
        input: NA
        output: cpuSet
        """
        if (parallelJobs != 0):
            return parallelJobs
        # do this function to get the parallel number
        cpuSet = multiprocessing.cpu_count()
        if (cpuSet > 1):
            return cpuSet
        else:
            return parallelTool.DEFAULT_PARALLEL_NUM

    @staticmethod
    def parallelExecute(func, paraList, parallelJobs=0):
        """
        function: Execution of python functions through multiple processes
        input: func, list
        output: list
        """
        jobs = parallelTool.getCpuCount(parallelJobs)
        if (jobs > len(paraList)):
            jobs = len(paraList)
        pool = ThreadPool(jobs)
        results = pool.map(func, paraList)
        pool.close()
        pool.join()
        return results


class CommandThread(threading.Thread):
    """
    The class is used to execute command in thread
    """

    def __init__(self, cmd):
        '''
        Constructor
        '''
        threading.Thread.__init__(self)
        self.command = cmd
        self.cmdStauts = 0
        self.cmdOutput = ""

    def run(self):
        """
        function: Run command
        input : NA
        output: NA
        """
        (self.cmdStauts, self.cmdOutput) = subprocess.getstatusoutput(self.command)
