#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import subprocess
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except Exception as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))

PORT_RANGE = (26000, 65535)
SYSCTL_FILE = "/etc/sysctl.conf"


class CheckSysPortRange(BaseItem):
    def __init__(self):
        super(CheckSysPortRange, self).__init__(self.__class__.__name__)

    def doCheck(self):
        output = g_file.readFile('/proc/sys/net/ipv4/ip_local_port_range')[0]
        smallValue = output.split()[0].strip()
        bigValue = output.split()[1].strip()
        if (int(bigValue) > PORT_RANGE[1] or int(smallValue) < PORT_RANGE[0]):
            self.result.val = "The value of net.ipv4.ip_local_port_range is %d %d. it should be %d %d" % (
                int(smallValue), int(bigValue), int(PORT_RANGE[0]), int(PORT_RANGE[1]))
            self.result.rst = ResultStatus.NG
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "The value of net.ipv4.ip_local_port_range is %d %d." % (int(smallValue), int(bigValue))
        self.result.raw = output

    def doSet(self):
        cmd = "sed -i '/net.ipv4.ip_local_port_range/d' %s" % SYSCTL_FILE
        cmd += " && echo 'net.ipv4.ip_local_port_range = 26000 65535' >> %s" % SYSCTL_FILE
        cmd += " && sysctl -p"
        (status, output) = subprocess.getstatusoutput(cmd)
        if (status != 0 and output.find('/proc/sys/net/ipv4/ip_local_port_range: No such file or directory') >= 0):
            raise Exception("Failed to set net.ipv4.ip_local_port_range.")
