#!/usr/bin/env python3
#-*- coding:utf-8 -*-

try:
    import sys
    import os
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))

deviceNeedRepair = []


class CheckIOConfigure(BaseItem):
    def __init__(self):
        super(CheckIOConfigure, self).__init__(self.__class__.__name__)

    def obtainDataDir(self, nodeInfo):
        dataDirList = []
        for inst in nodeInfo.datanodes:
            dataDirList.append(inst.datadir)
        for inst in nodeInfo.cmservers:
            dataDirList.append(inst.datadir)
        for inst in nodeInfo.coordinators:
            dataDirList.append(inst.datadir)
        for inst in nodeInfo.gtms:
            dataDirList.append(inst.datadir)
        if (hasattr(nodeInfo, 'etcds')):
            for inst in nodeInfo.etcds:
                dataDirList.append(inst.datadir)

        dataDirList.append(os.getenv("PGHOST"))
        dataDirList.append(os.getenv("GPHOME"))
        dataDirList.append(os.getenv("GAUSSHOME"))
        dataDirList.append(os.getenv("GAUSSLOG"))
        dataDirList.append("/tmp")
        return dataDirList

    def obtainDiskDir(self):
        cmd = "df -h -P /data* | grep -v 'Mounted' | awk '{print $6}'"
        output = SharedFuncs.runShellCmd(cmd)
        if output.lower().find("no such") >= 0:
            allDiskPath = ["/"]
        else:
            allDiskPath = output.split('\n')
        return allDiskPath

    def getDevices(self):
        pathList = []
        devices = []
        diskName = ""
        diskList = []
        diskList = self.getDisk()
        if (self.cluster):
            pathList = self.obtainDataDir(self.cluster.getDbNodeByName(self.host))
        else:
            pathList = self.obtainDiskDir()
        for path in pathList:
            if path.find('No such file or directory') >= 0 or path.find('no file systems processed') >= 0:
                self.result.rst = ResultStatus.ERROR
                self.result.val += "There are no cluster and no /data* directory."
                return devices
            cmd = "df -P -i %s" % path
            output = SharedFuncs.runShellCmd(cmd)
            # Filesystem      Inodes  IUsed   IFree IUse% Mounted on
            # /dev/xvda2     2363904 233962 2129942   10% /
            diskName = output.split('\n')[-1].split()[0]
            for i in diskList:
                if diskName.find(i) >= 0 and i not in devices:
                    devices.append(i)
        return devices

    def getDisk(self):
        cmd = "fdisk -l 2>/dev/null | grep 'Disk /dev/' | grep -v '/dev/mapper/' | awk '{ print $2 }'" \
              "| awk -F'/' '{ print $NF }'| sed s/:$//g"
        output = SharedFuncs.runShellCmd(cmd)
        return output.splitlines()

    def collectIOschedulers(self):
        devices = set()
        data = dict()
        files = self.getDevices()
        for f in files:
            fname = "/sys/block/%s/queue/scheduler" % f
            words = fname.split("/")
            if len(words) != 6:
                continue
            devices.add(words[3].strip())

        for d in devices:
            if (not d):
                continue
            device = {}
            scheduler = g_file.readFile("/sys/block/%s/queue/scheduler" % d)[0]
            words = scheduler.split("[")
            if len(words) != 2:
                continue
            words = words[1].split("]")
            if len(words) != 2:
                continue
            device["request"] = words[0].strip()
            for dead in scheduler.split():
                if dead.find("deadline") >= 0:
                    device["deadvalue"] = dead.split("[")[-1].split("]")[0]
                else:
                    continue
            data[d] = device
        return data

    def doCheck(self):
        global deviceNeedRepair
        deviceNeedRepair = []
        expectedScheduler = "deadline"
        data = self.collectIOschedulers()
        flag = True
        resultStr = ""
        for i in data.keys():
            result = ()
            expectedScheduler = data[i]["deadvalue"]
            request = data[i]["request"]
            if (request != expectedScheduler):
                result = (i, expectedScheduler)
                deviceNeedRepair.append(result)
                resultStr += "On device (%s) 'IO Request' RealValue '%s' ExpectedValue '%s'" % (
                    i, request.strip(), expectedScheduler)
                flag = False
        self.result.val = resultStr
        if flag:
            self.result.rst = ResultStatus.OK
            self.result.val = "All disk IO Request is deadline."
        else:
            self.result.rst = ResultStatus.NG

    def doSet(self):
        for dev, expectedScheduler in deviceNeedRepair:
            self.SetIOSchedulers(dev, expectedScheduler)

    def SetIOSchedulers(self, devname, expectedScheduler):
        """
        function : Set IO Schedulers
        input  : String
        output : NA
        """
        (_, initFile) = SharedFuncs.getTHPandOSInitFile()
        cmd = " echo %s >> /sys/block/%s/queue/scheduler" % (expectedScheduler, devname)
        cmd += " && echo \"echo %s >> /sys/block/%s/queue/scheduler\" >> %s" % (expectedScheduler, devname, initFile)
        SharedFuncs.runShellCmd(cmd)
