#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckLockState(BaseItem):
    def __init__(self):
        super(CheckLockState, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "select count(1) from pg_catalog.pg_stat_activity where instr(query, 'pgxc_lock_for_backup()') > 0" \
                 " or instr(query, 'pg_advisory_lock(65535,65535)') > 0;"
        self.result.raw = sqlcmd

        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        if ((int(output.strip()) - 1) != 0):
            self.result.rst = ResultStatus.NG
        else:
            self.result.rst = ResultStatus.OK
        self.result.val = output
