#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckLockNum(BaseItem):
    def __init__(self):
        super(CheckLockNum, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "select  count(*) from pg_catalog.pg_locks"
        self.result.raw = sqlcmd
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        self.result.rst = ResultStatus.OK
        self.result.val = output
